//	-------------------------------------------------------------------------
//	|	Name	:	Ali Raza Shaikh											|
//	|	Std #	:	1975 - C												|
//	|	Date	:	20 - 11 - 2003											|
//	|	Email	:	ali_raza_shaikh@yahoo.com								|
//	|	Website	:	www.programmersparadise.cjb.net							|
//	------------------------------------------------------------------------

// BinarySearchTree.h: interface for the BinarySearchTree class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BINARYSEARCHTREE_H__8FC4FE3C_478C_4778_84DA_844E22D10EB9__INCLUDED_)
#define AFX_BINARYSEARCHTREE_H__8FC4FE3C_478C_4778_84DA_844E22D10EB9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Nodes.cpp"
#include <fstream.h>

template <class T>

//------------------------------------------------------------------------------------
//				B I N A R Y  S E A R C H  T R E E  C L A S S
//------------------------------------------------------------------------------------


class BinarySearchTree
{
	private:
		TreeNode<T> * root;
		TreeNode<T> * current;	
		

	public:

		BinarySearchTree();
		~BinarySearchTree();		

		bool Empty();
		void Insert_Item(TreeNode<T>* & ,T);
		void Insert(T);
		void FindNode(TreeNode<T>* &,const T&);
		bool Find(const T&);
		void Delete_Tree(TreeNode<T>* &);
		void Delete(T&);
		void delete_item(TreeNode<T>* &,T&);
		void Delete_Root_Item(TreeNode<T>* &);

		void InOrderTraverseRec(TreeNode<T>* &);
		void PreOrderTraverseRec(TreeNode<T>* &);
		void PostOrderTraverseRec(TreeNode<T>* &);

		void Print_Tree(TreeNode<T>* &, int );
		void Print();

		int Height(void)
		{
			HighestRec(root);
		}

		void DeleteBinarySearchTree();

		void In_Order_Traversal()
		{
			InOrderTraverseRec(root);
		}

		void Pre_Order_Traversal()
		{
			PreOrderTraverseRec(root);
		}

		void Post_Order_Traversal()
		{
			PostOrderTraverseRec(root);
		}

		void Get(T,ofstream &);		
		void Get_Item(TreeNode<T> * &,T,ofstream &);
};


#endif // !defined(AFX_BINARYSEARCHTREE_H__8FC4FE3C_478C_4778_84DA_844E22D10EB9__INCLUDED_)
